#include <bits/stdc++.h>

#include <ext/pb_ds/assoc_container.hpp>
#include <ext/pb_ds/tree_policy.hpp>

#define ALL(a) (a).begin(), (a).end()
#define RALL(a) (a).rbegin(), (a).rend()

using namespace std;

using i16 = int16_t;
using i32 = int32_t;
using i64 = int64_t;
using i128 = __int128;
using u16 = uint16_t;
using u32 = uint32_t;
using u64 = uint64_t;
using u128 = unsigned __int128;
using f64 = double;
using f128 = long double;

template <typename T>
ptrdiff_t ssize(const T& a) {
  return static_cast<ptrdiff_t>(a.size());
}
template <typename K, typename V, typename Cmp = less<K>>
using ordered_map =
    __gnu_pbds::tree<K, V, Cmp, __gnu_pbds::rb_tree_tag,
                     __gnu_pbds::tree_order_statistics_node_update>;
template <typename T, typename Cmp = less<T>>
using ordered_set = ordered_map<T, __gnu_pbds::null_type, Cmp>;
template <typename T1, typename T2>
istream& operator>>(istream& is, pair<T1, T2>& a) {
  return is >> a.first >> a.second;
}
template <typename T1, typename T2>
ostream& operator<<(ostream& os, const pair<T1, T2>& a) {
  return os << a.first << " " << a.second;
}
template <typename T>
istream& operator>>(istream& is, vector<T>& a) {
  for (T& e : a) is >> e;
  return is;
}
template <typename T>
ostream& operator<<(ostream& os, const vector<T>& a) {
  for (const T& e : a) os << e << " ";
  return os;
}
template <typename T>
void chmin(T& a, const T& b) {
  if (a > b) a = b;
}
template <typename T>
void chmax(T& a, const T& b) {
  if (a < b) a = b;
}

void solve();

int main() {
  ios_base::sync_with_stdio(false);
  cin.tie(nullptr);
  i32 t;
  cin >> t;
  while (t--) solve();
  return 0;
}

constexpr f128 kEpsilon = 1e-9;
bool feq(f128 a, f128 b, f128 eps = kEpsilon) {
  return abs(a - b) <= eps;
}
bool fle(f128 a, f128 b, f128 eps = kEpsilon) {
  return a - b <= eps;
}
bool flt(f128 a, f128 b, f128 eps = kEpsilon) {
  return a - b < -eps;
}

struct vec2 {
  f128 x, y;

  bool operator<(vec2 a) const {
    return flt(x, a.x) || feq(x, a.x) && fle(y, a.y);
  }
};
struct seg2 {
  vec2 a, b;
};
struct line2 {
  f128 a, b, c;
};


bool is_parallel(line2 a, line2 b) {
  return feq(a.a * b.b, a.b * b.a);
}
optional<vec2> intersect(line2 a, line2 b) {
  if (is_parallel(a, b)) return nullopt;
  if (feq(b.a, 0)) swap(a, b);
  f128 cy = a.a / b.a;
  f128 y = (b.c * cy - a.c) / (a.b - b.b * cy);
  if (feq(b.b, 0)) swap(a, b);
  f128 cx = a.b / b.b;
  f128 x = (b.c * cx - a.c) / (a.a - b.a * cx);
  return vec2{x, y};
}
line2 get_line(seg2 s) {
  f128 dx = s.b.x - s.a.x, dy = s.b.y - s.a.y;
  f128 a = dy, b = -dx;
  f128 c = -(a * s.a.x + b * s.a.y);
  return {a, b, c};
}
optional<vec2> intersect(seg2 a, seg2 b) {
  optional<vec2> opt_p = intersect(get_line(a), get_line(b));
  if (!opt_p) return nullopt;
  vec2 p = opt_p.value();
  auto [a_x_lo, a_x_hi] = minmax(a.a.x, a.b.x);
  auto [a_y_lo, a_y_hi] = minmax(a.a.y, a.b.y);
  auto [b_x_lo, b_x_hi] = minmax(b.a.x, b.b.x);
  auto [b_y_lo, b_y_hi] = minmax(b.a.y, b.b.y);
  if (fle(a_x_lo, p.x) && fle(p.x, a_x_hi) && fle(a_y_lo, p.y) && fle(p.y, a_y_hi) &&
      fle(b_x_lo, p.x) && fle(p.x, b_x_hi) && fle(b_y_lo, p.y) && fle(p.y, b_y_hi)) {
    return p;
  }
  return nullopt;
}

void solve() {
  i32 n;
  cin >> n;
  vector<seg2> a(n);
  for (auto& e : a) {
    cin >> e.a.x >> e.a.y >> e.b.x >> e.b.y;
    if (e.a.x > e.b.x) {
      swap(e.a, e.b);
    }
  }
  vector<vector<pair<vec2, i32>>> intersection_points(n);
  for (int i = 0; i < n; ++i) {
    for (int j = i + 1; j < n; ++j) {
      optional<vec2> opt_p = intersect(a[i], a[j]);
      if (!opt_p.has_value()) continue;
      vec2 p = opt_p.value();
      intersection_points[i].emplace_back(p, j);
      intersection_points[j].emplace_back(p, i);
    }
  }
  map<pair<i32, i32>, vector<pair<i32, i32>>> g;
  for (int i = 0; i < n; ++i) {
    sort(ALL(intersection_points[i]));
    if (size(intersection_points[i]) <= 1) continue;
    pair<i32, i32> u, v;
    for (int j = 0; j < ssize(intersection_points[i]); ++j) {
      u = minmax(i, intersection_points[i][j].second);
      if (j > 0) {
        v = minmax(i, intersection_points[i][j - 1].second);
        g[u].push_back(v);
      }
      if (j < ssize(intersection_points[i]) - 1) {
        v = minmax(i, intersection_points[i][j + 1].second);
        g[u].push_back(v);
      }
    }
  }
  map<pair<i32, i32>, bool> visited;
  i32 ans = 0;
  auto dfs = [&](pair<i32, i32> u, pair<i32, i32> p, auto&& dfs) -> void {
    if (visited[u]) {
      ans++;
      return;
    }
    visited[u] = true;
    for (auto v : g[u]) {
      if (v == p) continue;
      dfs(v, u, dfs);
    }
  };
  for (auto [k, _] : g) {
    if (!visited[k]) dfs(k, k, dfs);
  }
  cout << ans / 2 + 1 << "\n";
}
